#!/bin/sh

# Reflash the Mizar32's AT32UC3A0128 with all relevant firmware
# by Martin Guy, 1 October 2010

# Exit if any command fails
set -e

echo Performing a JTAG Chip Erase command.
avr32program chiperase

echo
echo Programming boot loader
avr32program program -finternal@0x80000000,128Kb -cxtal -e -v -O0x80000000 -Fbin at32uc3a-isp-1.0.3.bin

echo
echo Programming ISP configuration word
# config word contains 0x929e58c7 in big-endian byte order.
# 929e identifies this as a config word,
# 58 selects PX16 ("BUTTON") as the line to activate the DFU USB bootloader,
# c7 is the CRC8 of the previous three bytes, generated by running
# "jacksum -a crc8" on a file containing the first three bytes.
avr32program program -finternal@0x80000000,128Kb -cxtal -e -v -O0x808001FC -Fbin mizar32-isp-cfg.bin

echo
echo Programming general-purpose fuse bits.
# the gp= word is the same at the default value, but with the top bit cleared
# so that DFU USB activation is dependent on the button instead of always on.
avr32program writefuses -finternal@0x80000000,128Kb gp=0x7C07FFFF

echo
echo Programming eLua interpreter
avr32program program -finternal@0x80000000,128Kb -cxtal -e -v elua_lualong_at32uc3a0128.elf

echo
echo Starting CPU execution.
avr32program run -R
